; Gibt "Simples Beispiel" aus
;
; Quelle:
;   https://www.c64-wiki.de/index.php/ACME
; Build:
;   acme <SOURCE>
; Run Emulator:
;   x64 <BIN>
; Start Program
;   sys 49152
;
	!to "tiny.o", cbm	; Setzen der Ausgabedatei und des Formats
; Mit diesem Pseudo-Opcode wird der Dateiname und das Format festgelegt.
; Das kann auch über die Kommandozeilenoptionen "-o" und "-f" gemacht
; werden.

	*= $c000	; Setzen des Programmzählers
; Das geht auch mit der Kommandozeilenoption "--setpc".

	basout = $ffd2	; explizite, globale Label Definition
; Damit ist "basout" als globales Label mit dem Wert $FFD2 definiert.

	; Eine Stringausgabeschleife:
	ldx #0
	beq +		; Schleifenstart
; '+' ist ein anonymes Vorwärtslabel. Andere sind "++", "+++", etc.
; Es kann wie ein jedes andere Label verwendet werden, aber verweist
; immer auf die nächst vorkommende Definition. Das erspart ein Ausdenken von Namen
; für unwichtige Label. Der Wert ist noch nicht gleich definiert und ACME setzt diesen
; erst beim zweiten Durchgang.

-	jsr basout	; Zeichen ausgeben
; '-' ist ein anonymes Rückwärtslabel. Andere sind "--", "---", etc.
; Es kann wie ein jedes andere Label verwendet werden, aber verweist
; immer auf die zuletzt vorkommende Definition. Das erspart ein Ausdenken von Namen
; für unwichtige Label. In dieser Zeile wird der Wert des Labels auf den des aktuellen
; Programmzählers gesetzt.

	inx		; erhöhe Zähler
+	lda .string,x	; hole Zeichen
; In dieser Zeile wird "+" auf den aktuellen Programmzähler gesetzt.
; ".string" ist ein lokales Label (weil es mit einem "." beginnt) und
; wird beim zweiten Durchgang von ACME ermittelt.

	bne -		; Prüfung, ob die Endekennung (=0) erreicht
; Hier ist die letzte Definition von "-" referenziert.

	rts

.string	!pet "Simples Beispiel", 13, 0
; Nun ist das Label ".string" auf den aktuellen Programmzähler gesetzt und
; alle Label sind definiert. Nach dem zweiten Durchgang von ACME wird die
; Binärdatei gespeichert. Der "!pet" Pseudo-Opcode speichert den String
; PetSCII-kodiert im Speicher als Byte-Werte.

; vim: ft=acme
; vim: noexpandtab tabstop=8 softtabstop=8
